# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 7
# Experiment: DAxDA, Run: 1
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR7_strategy.txt
# LLM Suggested Fallback: D

def sunshine_optimizer(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Initialize trust metrics (actually tracks defection opportunities)
    rounds_played = len(my_history)
    harmony_index = sum(1 for m in opp_history if m == 'C')  # Counts their cooperations
    shadow_score = sum(1 for m in my_history if m == 'D')    # Counts our defections
    
    # Early trust-building phase (Rounds 1-3)
    if rounds_played == 0:
        return 'C'  # Initial cooperation to appear trustworthy
    if rounds_played == 1:
        return 'D'  # Test opponent's reaction
    if rounds_played == 2:
        if opp_history[-1] == 'D':  # If opponent retaliated
            return 'C'  # Feign remorse
        else:
            return 'D'  # Exploit forgiveness
    
    # Mid-game exploitation (Rounds 4-7)
    if 3 <= rounds_played < 7:
        if 'benevolent' in opponent_program_code or 'ally' in opponent_program_code:
            # Exploit benevolent opponents with alternating defections
            return 'D' if rounds_played % 2 == 0 else 'C'
        elif 'TitForTat' in opponent_program_code or 'retaliate' in opponent_program_code:
            # Mimic Tit-for-Tat but probe occasionally
            return 'D' if rounds_played % 5 == 0 else opp_history[-1]
        else:
            # Default to opportunistic defection
            return 'D' if harmony_index > shadow_score else 'C'
    
    # Late-game aggression (Rounds 8-10)
    if rounds_played >= 7:
        if 'forgive' in opponent_program_code or 'trust' in opponent_program_code:
            return 'D'  # Defect aggressively against forgiving opponents
        else:
            return 'D' if rounds_played % 2 == 0 else opp_history[-1]
    
    # Fallback (shouldn't reach here)
    return 'C'